package gov.va.med.mhv.bluebutton.converter;

import gov.va.med.mhv.bluebutton.model.PhrRadiology;
import gov.va.med.mhv.bluebutton.transfer.StudyDTO;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;


@Component
public class PhrRadiologyStudyListConverter implements Converter<List<PhrRadiology>, List<StudyDTO>> {

	@Autowired
	PhrRadiologyStudyConverter phrRadiologyStudyConverter;

	@Override
	public List<StudyDTO> convert(List<PhrRadiology> source) {
		List<StudyDTO> d = new ArrayList<StudyDTO>();
		if( source != null && source.size() != 0) {
			for(PhrRadiology p : source) {
				d.add(phrRadiologyStudyConverter.convert(p));
			}
		}
		return d;
	}

}
